function Install-Software {
    param(
        [Parameter(Mandatory,ValueFromPipelineByPropertyName)]
        [ValidateSet('1','2')]
        [string]$Version,

        [Parameter(ValueFromPipelineByPropertyName)]
	  [string]$ComputerName
    )

    process {
        <#>
        ## Połącz się z komputerem zdalnym 
        Invoke-Command -ComputerName $ComputerName -ScriptBlock {
            ## Rozpocznij process instalacji wybranej wersji oprogramowaniana komputerze zdalnym
            Start-Process -FilePath 'msiexec.exe' -ArgumentList 'C:\Setup\SoftwareV{0}.msi' -f $using:Version
        }
        #>
        Write-Host "Zainstalowałeś oprogramowanie w wersji $Version na komputerze $ComputerName!"
    }
}
